#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# test_sap_rfc.py  -  Unittests for saprfc.py
#
# Copyright (C) 2018 PerFact Innovation GmbH & Co. KG <info@perfact.de>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

from ..daemondatasources import saprfc
import unittest
import json


class SapRfcTC(unittest.TestCase):

    def test_args(self):
        connector = ('ashost=myhost; SYSNR=1 ;Client=010; user = me ; '
                     'passfile=./foo.bar')
        paramdict = saprfc.connector2args(connector)
        self.assertEqual('myhost', paramdict.get('ashost', 'no'))
        self.assertEqual('1', paramdict.get('sysnr', 'no'))
        self.assertEqual('010', paramdict.get('client', 'no'))
        self.assertEqual('me', paramdict.get('user', 'no'))
        self.assertEqual('./foo.bar', paramdict.get('passfile', 'no'))

    def test_params(self):
        query_data = {'foo': 'bar', 'baz': 'boz'}
        query_json = json.dumps(query_data)
        params = saprfc.createParams(rfc_name='function', query=query_json)
        dict = json.loads(params)
        self.assertEqual('function', dict.get('name', 'no'))
        self.assertEqual('bar', dict.get('params', {}).get('foo', 'no'))
